#import "CIHatchedScreenClass.h"

#define gOurBundle [NSBundle bundleForClass:[self class]]

#define gUserDefaults [NSUserDefaults standardUserDefaults]

@implementation CIHatchedScreenClass

- (id)initWithManager:(PluginData *)data
{
	pluginData = data;
	[NSBundle loadNibNamed:@"CIHatchedScreen" owner:self];
	
	return self;
}

- (int)type
{
	return 0;
}

- (NSString *)name
{
	return [gOurBundle localizedStringForKey:@"name" value:@"Hatched Screen" table:NULL];
}

- (NSString *)groupName
{
	return [gOurBundle localizedStringForKey:@"groupName" value:@"Halftone" table:NULL];
}

- (NSString *)sanity
{
	return @"Seashore Approved (Bobo)";
}

- (void)run
{
	if ([gUserDefaults objectForKey:@"CIHatchedScreen.width"])
		dotWidth = [gUserDefaults integerForKey:@"CIHatchedScreen.width"];
	else
		dotWidth = 6;
	if ([gUserDefaults objectForKey:@"CIHatchedScreen.angle"])
		angle = [gUserDefaults floatForKey:@"CIHatchedScreen.angle"];
	else
		angle = 0.0;
	if ([gUserDefaults objectForKey:@"CIHatchedScreen.sharpness"])
		sharpness = [gUserDefaults floatForKey:@"CIHatchedScreen.sharpness"];
	else
		sharpness = 0.7;
			
	if (dotWidth < 2 || dotWidth > 100)
		dotWidth = 6;
	if (angle < -1.57 || angle > 1.57)
		angle = 0.0;
	if (sharpness < 0.0 || sharpness > 1.0)
		sharpness = 0.7;
			
	[dotWidthLabel setStringValue:[NSString stringWithFormat:@"%d", dotWidth]];
	[dotWidthSlider setIntValue:dotWidth];
	[angleLabel setStringValue:[NSString stringWithFormat:@"%.2f", angle]];
	[angleSlider setFloatValue:angle * 100.0];
	[sharpnessLabel setStringValue:[NSString stringWithFormat:@"%.2f", sharpness]];
	[sharpnessSlider setFloatValue:sharpness];
	
	refresh = YES;
	success = NO;
	[self preview:self];
	if ([pluginData window])
		[NSApp beginSheet:panel modalForWindow:[pluginData window] modalDelegate:NULL didEndSelector:NULL contextInfo:NULL];
	else
		[NSApp runModalForWindow:panel];
	// Nothing to go here
}

- (IBAction)apply:(id)sender
{
	if (refresh) [self execute];
	[pluginData apply];
	
	[panel setAlphaValue:1.0];
	
	[NSApp stopModal];
	if ([pluginData window]) [NSApp endSheet:panel];
	[panel orderOut:self];
	success = YES;
		
	[gUserDefaults setInteger:dotWidth forKey:@"CIHatchedScreen.width"];
	[gUserDefaults setFloat:angle forKey:@"CIHatchedScreen.angle"];
	[gUserDefaults setFloat:sharpness forKey:@"CIHatchedScreen.sharpness"];
}

- (void)reapply
{
	[self execute];
	[pluginData apply];
}

- (BOOL)canReapply
{
	return success;
}

- (IBAction)preview:(id)sender
{
	if (refresh) [self execute];
	[pluginData preview];
	refresh = NO;
}

- (IBAction)cancel:(id)sender
{
	[pluginData cancel];
	
	[panel setAlphaValue:1.0];
	
	[NSApp stopModal];
	[NSApp endSheet:panel];
	[panel orderOut:self];
	success = NO;
}

- (IBAction)update:(id)sender
{
	dotWidth = [dotWidthSlider intValue];
	angle = roundf([angleSlider floatValue]) / 100.0;
	sharpness = [sharpnessSlider floatValue];
	if (angle > -0.015 && angle < 0.00) angle = 0.00; /* Force a zero point */
	
	[panel setAlphaValue:1.0];
	
	[dotWidthLabel setStringValue:[NSString stringWithFormat:@"%d", dotWidth]];
	[angleLabel setStringValue:[NSString stringWithFormat:@"%.2f", angle]];
	[sharpnessLabel setStringValue:[NSString stringWithFormat:@"%.2f", sharpness]];
	
	refresh = YES;
	if ([[NSApp currentEvent] type] == NSLeftMouseUp) { 
		[self preview:self];
		if ([pluginData window]) [panel setAlphaValue:0.4];
	}
}

- (void)execute
{
    int width = [pluginData width];
    int height = [pluginData height];
    
    CIFilter *filter = [CIFilter filterWithName:@"CIHatchedScreen"];
    if (filter == NULL) {
        @throw [NSException exceptionWithName:@"CoreImageFilterNotFoundException" reason:[NSString stringWithFormat:@"The Core Image filter named \"%@\" was not found.", @"CIHatchedScreen"] userInfo:NULL];
    }
    [filter setDefaults];
    [filter setValue:[CIVector vectorWithX:width / 2 Y:height / 2] forKey:@"inputCenter"];
    [filter setValue:[NSNumber numberWithInt:dotWidth] forKey:@"inputWidth"];
    [filter setValue:[NSNumber numberWithFloat:angle] forKey:@"inputAngle"];
    [filter setValue:[NSNumber numberWithFloat:sharpness] forKey:@"inputSharpness"];
    
    applyFilter(pluginData,filter);
}

+ (BOOL)validatePlugin:(PluginData*)pluginData
{
    if ([pluginData channel] == kAlphaChannel)
        return NO;
    
    if ([pluginData spp] == 2)
        return NO;
	
	return YES;
}

@end
